#version 330
#extension GL_EXT_gpu_shader4 : enable
// Ray marching in the KalisetMod01.fsh by  janiorca

//https://www.shadertoy.com/view/tdVGDy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define steps 850.0
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec3 pos = vec3( gl_FragCoord.xy/iResolution.x - vec2( 0.5, 0.5 ), 0.0 );

    vec3 origin = vec3( 0.0, 0.0, 1.0 );
    vec3 ray_dir = pos - origin ;
    vec3 c = vec3( -1.05241, -.8134335, -.95455);

    vec3 col;
    float pitch = iTime / 5.0;
    float cos_a = cos(pitch);
    float sin_a = sin(pitch);
    float yaw = 0.6+sin(iTime/2.0)/3.0;
    float sin_b = sin( yaw );
    float cos_b = cos( yaw );
    mat3 rot_m = mat3( cos_a, 0.0, -sin_a,
                    sin_a*-sin_b, cos_b, cos_a*-sin_b,
                    sin_a*cos_b, sin_b, cos_a*cos_b );                        

    origin = rot_m*vec3( 0,0,1.0  + sin(iTime*0.9 ) * .55 ) ;
    origin.y = .9;
    ray_dir = rot_m*ray_dir;

    for( float depth = 60.0; depth < steps; depth ++ ) {
        pos = origin +  depth * ray_dir * 0.003;
        ray_dir = ray_dir * 1.003;
        vec3 prev  = vec3( 1,1,1), prev_prev;
        for( int idx=0; idx< 7;idx++ ) 
        {
            prev_prev = prev;
            prev = pos;
            pos = abs(pos);
            pos =  pos / dot( pos, pos ) + c;
            if( dot( pos,pos  )  > 6.89 ) 
            {
                if( idx  >3  ) 
                {
                    col = normalize( prev - prev_prev ) / 2.0 + vec3( 0.5, 0.5, 0.5 );
                } else  
                {

                  col = normalize( -prev-prev_prev ) / 2.0 + vec3( 0.5, 0.5, 0.5 );
                } 
                depth = 100000.0;
                break;
            }
        }
    }    
    gl_FragColor = vec4(col,1.0);
}